eval '(exit $?0)' && eval 'exec perl -w -S $0 ${1+"$@"}'
    & eval 'exec perl -w -S $0 $argv:q'
    if 0;

#
# Copyright (c) 2006 Mellanox Technologies. All rights reserved.
#
# This Software is licensed under one of the following licenses:
#
# 1) under the terms of the "Common Public License 1.0" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/cpl.php.
#
# 2) under the terms of the "The BSD License" a copy of which is
#    available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/bsd-license.php.
#
# 3) under the terms of the "GNU General Public License (GPL) Version 2" a
#    copy of which is available from the Open Source Initiative, see
#    http://www.opensource.org/licenses/gpl-license.php.
#
# Licensee has the right to choose one of the above licenses.
#
# Redistributions of source code must retain the above copyright
# notice and one of the license notices.
#
# Redistributions in binary form must reproduce both the above copyright
# notice, one of the license notices in the documentation
# and/or other materials provided with the distribution.
#
#  $Id$
#
#  Author: Vladimir Sokolovsky <vlad@mellanox.co.il>
#

use strict;
use threads;
use threads::shared;

sub usage
{
   print "\n Usage: $0 [-p <primary IPoIB interface>] [-s <secondary IPoIB interface>] [--with-arping] [--with-multicast] [-v] [-vv]\n";
   print "\n";
   print "  -p                  - primary IPoIB interface (default: ib0)\n";
   print "  -s                  - secondary IPoIB interface (default: ib1)\n";
   print "  --with-arping       - use modified arping utility to send unsolicited ARP REPLY\n";
   print "  --with-multicast    - support applications that are using multicast\n";
   print "  -v                  - verbose output\n";
   print "  -vv                 - more verbose output\n";
   print "\n";
}

$| = 1;
my $netdir;
my $config;
my $verbose = 0;
my $verbose2 = 0;
my $with_arping = 0;
my $with_multicast = 0;
my $mc_thread;
my $mm_thread;

# The primary and secondary variables are user defined and will not be changed.
my $primary : shared;
$primary = 'ib0';
my $secondary : shared;
$secondary = 'ib1';
my $interface;
my $cont = 1;

my $num_of_child_if : shared;
$num_of_child_if = 0;

my @maddrs : shared;
my @maddrs6 : shared;
my %hmaddr = ();
my %hmaddr6 = ();
my @child_ifs : shared;
my %ifcfg = ();

while ( $#ARGV >= 0 ) {

   my $cmd_flag = shift(@ARGV);

    if ( $cmd_flag eq "-p" ) {
        $primary = shift(@ARGV);
    } elsif ( $cmd_flag eq "-s" ) {
        $secondary = shift(@ARGV);
    } elsif ( $cmd_flag eq "-v" ) {
        $verbose = 1;
    } elsif ( $cmd_flag eq "-vv" ) {
        $verbose = 1;
        $verbose2 = 1;
    } elsif ( $cmd_flag eq "--with-arping" ) {
        $with_arping = 1;
    } elsif ( $cmd_flag eq "--with-multicast" ) {
        $with_multicast = 1;
    } else {
        &usage();
        exit 1;
    }
}

if ( $primary eq $secondary ) {
    print "\nipoib_ha configuration error: primary and secondary interfaces should be different\n\n";
    exit 1;
}

my $mcast_cache = '/var/cache/mcast.cache' . '.' . $primary . '.' . $secondary;
unlink($mcast_cache);

# active_if is a currently active interface.
# the default value is set to the primary
my $active_if : shared;
$active_if = 'none';

sub get_cfg
{
    my $config = shift @_;

    print "get_cfg: Got $config\n" if ( $verbose );
        
    my $name = $config;
    $name =~ s@.*ifcfg-@@;

    $ifcfg{$name}{'HA'} = 0;
    $ifcfg{$name}{'status'} = '';
    $ifcfg{$name}{'DEVICE'} = $name;
    $ifcfg{$name}{'pkey'} = get_pkey($name);
    $ifcfg{$name}{'mode'} = get_mode($name);
    $ifcfg{$name}{'mtu'} = get_mtu($name);

    while ( ! open ( IFH , $config ) ) {
        print "Can't open config $config: $!\n" if ( $verbose );
        sleep(3);
    }

    while (<IFH>) {
        next unless not m@(\#).*@;
        my $key = (split ( "=", $_) )[0];
        chomp $key;
        my $value = (split ( "=", $_) )[1];
        $value =~ s/\'//g;
        chomp $value;

        $ifcfg{$name}{$key} = $value;
        
    }
    close IFH || die "Can't close config $config: $!";

    # return %ifcfg;

}

sub print_cfg
{
    my %cfg = @_;
    print "\nDate:" . localtime(time) . "\n";
    print "Bond:\n";
    print "======================================\n";
    for my $key ( keys %cfg ) {
        print $key . ' = ' . $cfg{$key} . "\n";
    }
    print "\n";
}

sub print_ifcfg
{
    my %cfg = @_;
    print "\n\nDate:" . localtime(time) . "\n";
    for my $key ( keys %cfg ) {
        print "$key:\n";
        print "======================================\n";
        for my $subkey ( keys %{$cfg{$key}} ) {
            print $subkey . ' = ' . $cfg{$key}->{$subkey} . "\n";
        }
        print "\n";
    }
}

sub is_newmaddr
{
    my $addr;
    my $if;
    my $family;
    ($addr, $if, $family) = @_;
    my @lines = ();
    
    open (CHK, "/sbin/ipmaddr show $if |");
    while ( <CHK> ) {
        next unless m@inet[6]*@;
        push @lines, $_;
    }
    close CHK;

    if ( grep { /\b$addr\b/ } @lines ) {
        return 1;
    }
    
    return 0;
}

# Set network environment directory following the linux distribution
if ( -f "/etc/SuSE-release" ) {
    $netdir = '/etc/sysconfig/network';
} else {
    $netdir = '/etc/sysconfig/network-scripts';
}
    

$config = $netdir . '/' . 'ifcfg-' . $primary;

if ( not -f $config )
{
    print "No configuration file found for IPoIB primary interface.\n";
    print "Exiting...\n";
    exit 1;
}

# Get the configuration of the primary interface
get_cfg($config);

# Check whether primary interface got child interfaces
my $sysnetdir = '/sys/class/net/';

for my $child_if ( <$sysnetdir$primary.*> ) {
        $child_if =~ s@$sysnetdir@@;
        $config = $netdir . '/' . 'ifcfg-' . $child_if;
        push ( @child_ifs , $child_if);
        get_cfg($config);
        
        $num_of_child_if ++;
}

if ( $num_of_child_if ) {
        if ( $verbose ) {
                print "Found $num_of_child_if child interfaces\n"; 
                for my $i ( 0 .. $#child_ifs ) {
                        print "Found child interface $child_ifs[$i]\n";
                }
        }
}

my %bond = %{$ifcfg{$primary}};
if ( $verbose ) {
    print_ifcfg(%ifcfg);
    print_cfg(%bond);
}

# Get IPoIB multicast groups
sub get_maddrs
{
    @maddrs = ();
    @maddrs6 = ();
    print "get_maddrs: check multicast for  $bond{'DEVICE'}\n" if ( $verbose );
    open (MCAST, "/sbin/ipmaddr show $bond{'DEVICE'} |");
    my $i = 0;
    while ( <MCAST> ) {
        next if (not m@inet[6]*@ or m/\b224.0.0.251\b/ or m/\b224.0.0.1\b/ or m/\bff02::1\s+/);
        my $line = $_;
        $line =~ s/^\s+//;
        $line =~ s/\s+$//;
        my $family = ( split(" ", $line) )[0];
        my $maddr = ( split (" ", $line) )[1];
        if ( $maddr ) {
            if ( $family eq "inet6" ) {
                print "get_maddrs: $bond{'DEVICE'}: maddr inet6: $maddr\n" if ( $verbose );
                push (@maddrs6, $maddr);
            } else {
                print "get_maddrs: $bond{'DEVICE'}: maddr inet: $maddr\n" if ( $verbose );
                push (@maddrs, $maddr);
            }
        }
        
    }
    close (MCAST);
    
    if ( $num_of_child_if ) {
        for my $i ( 0 .. $#child_ifs ) {
                my $child_if = $child_ifs[$i];
                open (MCAST, "/sbin/ipmaddr show $child_if |");
                my $i = 0;
                while ( <MCAST> ) {
                    next if (not m@inet[6]*@ or m/\b224.0.0.251\b/ or m/\b224.0.0.1\b/ or m/\bff02::1\s+/);
                    my $line = $_;
                    $line =~ s/^\s+//;
                    $line =~ s/\s+$//;
                    my $family = ( split(" ", $line) )[0];
                    my $maddr = ( split (" ", $line) )[1];
                    if ( $maddr ) {
                        if ( $family eq "inet6" ) {
                            print "get_maddrs: $child_if: maddr inet6: $maddr\n" if ( $verbose );
                            push @{ $hmaddr6{$child_if} }, $maddr;
                        } else {
                            print "get_maddrs: $child_if: maddr inet: $maddr\n" if ( $verbose );
                            push @{ $hmaddr{$child_if} }, $maddr;
                        }
                    }
                }
                close (MCAST);
        }
    }
}

sub set_action
{
    my $action;
    my $family;
    my $ipaddr;
    my $multicast_addr;
    my $ifindex;

    ( $action, $family, $ipaddr, $multicast_addr, $ifindex) = @_;
    print "set_action: Action: $action, Family: $family, IP: $ipaddr, Multicast Address: $multicast_addr, Ifindex: $ifindex\n" if ( $verbose );
    open (MC, ">> $mcast_cache") or die "Can't open $mcast_cache: $!\n";
        printf MC "$action $family $ipaddr $multicast_addr $ifindex\n";
    close MC;
}

sub get_pkey
{
    my $name = shift @_;
    while ( ! open (IF, "/sys/class/net/$name/pkey") ) {
        print "get_pkey: Can't open /sys/class/net/$name/pkey: $!\n";
        sleep(3);
    }
    my $pkey = <IF>;
    chomp $pkey;
    close (IF);
    $pkey =~ s/0x//; 
    return $pkey;
}

# Get IPoIB interface mode (connected/datagram)
sub get_mode
{
    my $name = shift @_;
    while ( ! open (IF, "/sys/class/net/$name/mode") ) {
        print "get_mode: Can't open /sys/class/net/$name/mode: $!\n";
        sleep(3);
    }
    my $mode = <IF>;
    chomp $mode;
    close (IF);
    $mode =~ s/0x//; 
    return $mode;
}

# Get IPoIB interface mtu
sub get_mtu
{
    my $name = shift @_;
    while ( ! open (IF, "/sys/class/net/$name/mtu") ) {
        print "get_mtu: Can't open /sys/class/net/$name/mtu: $!\n";
        sleep(3);
    }
    my $mtu = <IF>;
    chomp $mtu;
    close (IF);
    $mtu =~ s/0x//; 
    return $mtu;
}

sub get_ifindex
{
    my $name = shift @_;
    while ( ! open (IF, "/sys/class/net/$name/ifindex") ) {
        print "get_ifindex: Can't open /sys/class/net/$name/ifindex: $!\n";
        sleep(3);
    }
    my $ifindex = <IF>;
    chomp $ifindex;
    close (IF);
    return $ifindex;
}

sub set_down
{
    my $ifdown = shift @_;
    print "\nDate:" . localtime(time) . "\n" if ( $verbose );
    system ("/sbin/ifconfig $ifdown 0.0.0.0 > /dev/null 2>&1");
    if ( $num_of_child_if ) {
        for my $i ( 0 .. $#child_ifs ) {
                my $child_if = $child_ifs[$i];
                print "set_down: Going to set down $ifdown.$ifcfg{$child_if}{'pkey'}.\n" if ( $verbose );
                system ("/sbin/ifconfig $ifdown.$ifcfg{$child_if}{'pkey'} 0.0.0.0 > /dev/null 2>&1");
        }                                        

    }

}

sub set_up_bond
{
    print "\nDate:" . localtime(time) . "\n" if ( $verbose );
    print "set_up_bond: Going to set up $bond{'DEVICE'} with $bond{'IPADDR'}\n" if ( $verbose );
    if ( $bond{'BROADCAST'} ) {
        system ("/sbin/ifconfig $bond{'DEVICE'} $bond{'IPADDR'} netmask $bond{'NETMASK'} broadcast $bond{'BROADCAST'} > /dev/null 2>&1");
    }
    else {
        system ("/sbin/ifconfig $bond{'DEVICE'} $bond{'IPADDR'} netmask $bond{'NETMASK'} > /dev/null 2>&1");
    }

    if ( $bond{'mode'} eq "connected" ) {
        print "Set connected mode for $bond{'DEVICE'} with mtu $bond{'mtu'}\n" if ( $verbose );
        system ("echo connected > /sys/class/net/$bond{'DEVICE'}/mode");
        system ("/sbin/ifconfig $bond{'DEVICE'} mtu $bond{'mtu'}");
    }

    if ( $num_of_child_if ) {
        for my $i ( 0 .. $#child_ifs ) {
                my $child_if = $child_ifs[$i];
                print "set_up_bond: Going to set up $bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'} with $ifcfg{$child_if}{'IPADDR'}.\n" if ( $verbose );
                print "set_up_bond: Set pkey $ifcfg{$child_if}{'pkey'} for $bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'}\n" if ( $verbose );
                system ("echo 0x$ifcfg{$child_if}{'pkey'} > /sys/class/net/$bond{'DEVICE'}/create_child");

                if ( $ifcfg{$child_if}{'BROADCAST'} ) {
                        system ("/sbin/ifconfig $bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'} $ifcfg{$child_if}{'IPADDR'} netmask $ifcfg{$child_if}{'NETMASK'} broadcast $ifcfg{$child_if}{'BROADCAST'} > /dev/null 2>&1");
                }
                else {
                        system ("/sbin/ifconfig $bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'} $ifcfg{$child_if}{'IPADDR'} netmask $ifcfg{$child_if}{'NETMASK'} > /dev/null 2>&1");
                }
               
                if ( $bond{'DEVICE'}.$ifcfg{$child_if}{'mode'} eq "connected" ) {
                    print "Set connected mode for $bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'} with mtu $bond{'DEVICE'}.$ifcfg{$child_if}{'mtu'}\n" if ( $verbose );
                    system ("echo connected > /sys/class/net/$bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'}/mode");
                    system ("/sbin/ifconfig $bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'} mtu $bond{'DEVICE'}.$ifcfg{$child_if}{'mtu'}");
                }
        }

    }

    if ( $with_multicast ) {
        for my $i ( 0 .. $#maddrs ) {
            if ( ( my $rc = is_newmaddr($maddrs[$i], $bond{'DEVICE'}, "inet") ) == 0 ) {
                set_action("add", "inet", $bond{'IPADDR'}, $maddrs[$i], $bond{'ifindex'});
            }
            else {
                print "set_up_bond: Existing multicast address $bond{'IPADDR'} $i = $maddrs[$i]\n" if ( $verbose );
            }
        }
        for my $i ( 0 .. $#maddrs6 ) {
            if ( ( my $rc = is_newmaddr($maddrs6[$i], $bond{'DEVICE'}, "inet6") ) == 0 ) {
                set_action("add", "inet6", $bond{'IPADDR'}, $maddrs6[$i], $bond{'ifindex'});
            }
            else {
                print "set_up_bond: Existing multicast address for $bond{'DEVICE'} $i = $maddrs6[$i]\n" if ( $verbose );
            }
        }
        if ( $num_of_child_if ) {
            for my $i ( 0 .. $#child_ifs ) {
                my $child_if = $child_ifs[$i];
                my $child_ifindex = get_ifindex($bond{'DEVICE'} . '.' . $ifcfg{$child_if}{'pkey'});
                for my $j ( 0 .. $#{ $hmaddr{$child_if} } ) {
                    if ( ( my $rc = is_newmaddr($hmaddr{$child_if}[$j], $bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'}, "inet") ) == 0 ) {
                        set_action("add", "inet", $ifcfg{$child_if}{'IPADDR'}, $hmaddr{$child_if}[$j], $child_ifindex);
                    }
                    else {
                        print "set_up_bond: Existing multicast address for $bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'} $j = $hmaddr{$child_if}[$j]\n" if ( $verbose );
                    }
                }
                for my $j ( 0 .. $#{ $hmaddr6{$child_if} } ) {
                    if ( ( my $rc = is_newmaddr($hmaddr6{$child_if}[$j], $bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'}, "inet6") ) == 0 ) {
                        set_action("add", "inet6", $ifcfg{$child_if}{'IPADDR'}, $hmaddr6{$child_if}[$j], $child_ifindex);
                    }
                    else {
                        print "set_up_bond: Existing multicast address $bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'} $j = $hmaddr6{$child_if}[$j]\n" if ( $verbose );
                    }
                }
            }
        }
    }
    # Send unsolicited arp reply to update neighbours
    if ( $with_arping ) {
        print "set_up_bond: Arping $bond{'DEVICE'} $bond{'IPADDR'}.\n" if ( $verbose );
        system("/sbin/arping -c 3 -b -U -A -I $bond{'DEVICE'} $bond{'IPADDR'} > /dev/null 2>&1");

        if ( $num_of_child_if ) {
            for my $i ( 0 .. $#child_ifs ) {
                    my $child_if = $child_ifs[$i];
                    print "set_up_bond: Arping $bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'} with $ifcfg{$child_if}{'IPADDR'}.\n" if ( $verbose );
                    system ("/sbin/arping -c 3 -b -U -A -I $bond{'DEVICE'}.$ifcfg{$child_if}{'pkey'} $ifcfg{$child_if}{'IPADDR'} > /dev/null 2>&1");
                   
            }

        }

    }

}

# Migrate IPoIB configuration to the new_active IPoIB interface
sub migrate_conf
{
    my $new_active = shift @_;
    if ( $with_multicast ) {
        get_maddrs();
    }

    my $other = get_other( $new_active );
    print "migrate_conf: Migrating from $other to $new_active\n" if ( $verbose );
    # Disable failed active_if device
    set_down( $other );
    $bond{'DEVICE'} = $new_active;
    $bond{'ifindex'} = get_ifindex( $new_active );

    # Setup secondary device
    set_up_bond();

}

# Check if some of the multicst groups where removed from the active_if IPoIB port
# And update mcast_cache file
sub monitor_multicast
{
    while ( 1 )
    {
        # Wait for active_if IPoIB interface failure
        if ( not -f $mcast_cache ) {
            sleep (1);
            print "monitor_multicast: Waiting for activation\n" if ( $verbose2 );
            next;
        }
        my $i;
        my @lines = ();
         
        my $other = get_other( $active_if );
        open (MCASTMON, "/sbin/ipmaddr show $other |");
        while (<MCASTMON>) {
            next unless m@inet[6]*@;
            push @lines, $_;
        }
        close (MCASTMON);

        print "monitor_multicast: sizeof maddrs: $#maddrs\n" if ( $verbose2 );
        print "monitor_multicast: sizeof maddrs6: $#maddrs6\n" if ( $verbose2 );
        for $i ( 0 .. $#maddrs6 ) {
            if (not grep  { /$maddrs6[$i]/ } @lines ) {
                print "monitor_multicast: Removing maddr inet6: $maddrs6[$i]\n" if ( $verbose2 );
                set_action("del", "inet6", $bond{'IPADDR'}, $maddrs6[$i], $bond{'ifindex'});
                splice (@maddrs6, $i, 1);
            }
        }
        for $i ( 0 .. $#maddrs ) {
            if (not grep  { /$maddrs[$i]/ } @lines ) {
                print "monitor_multicast: Removing maddr inet: $maddrs[$i]\n" if ( $verbose2 );
                set_action("del", "inet", $bond{'IPADDR'}, $maddrs[$i], $bond{'ifindex'});
                splice (@maddrs, $i, 1);
            }
        }

        if ( $num_of_child_if ) {
                for my $i ( 0 .. $#child_ifs ) {
                        my @lines = ();
                        my $child_if = $child_ifs[$i];
                        open (MCASTMON, "/sbin/ipmaddr show $other.$ifcfg{$child_if}{'pkey'} |");
                        while (<MCASTMON>) {
                            next unless m@inet[6]*@;
                            push @lines, $_;
                        }
                        close (MCASTMON);
                        print "monitor_multicast: sizeof hmaddr: $#{ $hmaddr{$child_if}}\n" if ( $verbose2 );
                        print "monitor_multicast: sizeof hmaddr6: $#{ $hmaddr6{$child_if}}\n" if ( $verbose2 );
                        for my $j ( 0 .. $#{ $hmaddr{$child_if} } ) {
                            if (not grep { /$hmaddr{$child_if}[$j]/ } @lines ) {
                                my $child_ifindex = get_ifindex($bond{'DEVICE'} . '.' . $ifcfg{$child_if}{'pkey'});
                                set_action("del", "inet", $ifcfg{$child_if}{'IPADDR'}, $hmaddr{$child_if}[$j], $child_ifindex);
                                splice (@{ $hmaddr{$child_if} }, $j, 1);
                            }
                        }
                        for my $j ( 0 .. $#{ $hmaddr6{$child_if} } ) {
                            if (not grep { /$hmaddr6{$child_if}[$j]/ } @lines ) {
                                my $child_ifindex = get_ifindex($bond{'DEVICE'} . '.' . $ifcfg{$child_if}{'pkey'});
                                set_action("del", "inet6", $ifcfg{$child_if}{'IPADDR'}, $hmaddr6{$child_if}[$j], $child_ifindex);
                                splice (@{ $hmaddr6{$child_if} }, $j, 1);
                            }
                        }

                }
        }
        sleep(2);
    }
}

# Join/remove to/from the multicast groups the secondary IPoIB interface
sub mcasthandle
{
    system ("mcasthandle $mcast_cache");
}

sub is_up
{
    my $ifcheck = shift @_;
    open(IFSTATUS, "/sbin/ip link show dev $ifcheck |");
    while ( <IFSTATUS> ) {
            next unless m@(\s$ifcheck).*@;
        if( m/<BROADCAST,MULTICAST,UP>/ ) {
            close(IFSTATUS);
            return 1;
        }
    }
    close(IFSTATUS);
    return 0;

}

sub is_carrier
{
    my $ifcheck = shift @_;
    open(IFSTATUS, "/sbin/ip link show dev $ifcheck |");
    while ( <IFSTATUS> ) {
            next unless m@(\s$ifcheck).*@;
        if( m/NO-CARRIER/ ) {
            close(IFSTATUS);
            return 0;
        }
    }
    close(IFSTATUS);
    return 1;
}

sub get_other
{
    my $given = shift @_;
    if ( $given eq $primary ) {
        return $secondary;
    } else {
        return $primary;
    }
}

# Wait for one of the interfaces to be active.
# We should wait enough time to start from primary interface
#   while interfaces configured by SM.
while ( $active_if eq 'none' ) {
        print "Wait for one of the interfaces to be active\n" if ( $verbose );
        sleep(5);
        if ( is_carrier ( $primary ) ) {
                set_down( $secondary );
                $active_if = $primary;
        } elsif ( is_carrier ( $secondary ) ) {
                set_down( $primary );
                migrate_conf( $secondary );
                $active_if = $secondary;
        }
}

if ( $with_multicast ) {
    $mc_thread = threads->new(\&mcasthandle);
    $mm_thread = threads->new(\&monitor_multicast);
}

open ( MONITOR, "/sbin/ip monitor link |" );

while ( <MONITOR> ) {

    next unless m@(\sib[0-9]+:).*@;
    $interface = ( split ( ":" , $_ ) )[1];
    $interface =~ s/\s//g;

    if ( ( $interface ne $primary ) and ( $interface ne $secondary ) ) {
        next;
    }

    my $has_carrier = is_carrier ( $interface );

    if ( not $has_carrier ) {
        print "Got NO-CARRIER event on $interface.\n" if ( $verbose );
        if ( is_carrier ( $interface ) ) {
            print "Got NO-CARRIER but $interface is UP\n" if ( $verbose );
        }

        print "Interface $interface is down.\n" if ( $verbose );
        print "Currently Active : $active_if\n" if ( $verbose );
        if ( $interface eq $active_if ) {
            my $other = get_other( $interface );
            if ( is_carrier ( $other ) ) {
                print "Other device: $other is UP\n" if ( $verbose );
                migrate_conf( $other );
                $active_if = $other;
            }
            else {
                print "Both interfaces are down\n" if ( $verbose );
                $active_if = 'none';
                next;
            }

        }
    
    } else {

            if  ( not is_carrier ( $interface ) ) {
                print "****** Got CARRIER-ON but $interface is DOWN\n" if ( $verbose );
            }

            print "Got CARRIER-ON event on $interface.\n" if ( $verbose );
            if ( $active_if eq 'none' ) {
                migrate_conf( $interface );
                $active_if = $interface;
            }
    }

}



if ( $with_multicast ) {
    $mc_thread->detach();
    $mm_thread->detach();
}
my $rc = close (MONITOR);
exit($rc);

